/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Header File for Edit Convenience Functions.

#pragma once

HRESULT __declspec(dllexport) DeleteLines(ISet *objectSet1) ;

HRESULT __declspec(dllexport) OffsetChain(ISet *lineSet, double offsetDistance, long offsetDirection) ;

HRESULT __declspec(dllexport) TranslateObjects(double xDistance, double yDistance, ISet *objectSet1) ;

HRESULT __declspec(dllexport) RotateObjects(double angle, ISet *objectSet1) ;

HRESULT __declspec(dllexport) ScaleObjects(double scaleFactor, ISet *objectSet1) ;

HRESULT __declspec(dllexport) RectangularDuplicate(double xNumber, double yNumber, double xSpacing,
							 double ySpacing, ISet *objectSet1) ;

HRESULT __declspec(dllexport) DuplicateLines(ISketch *sketch1, ISet *objectSet1, IMatrix *matrix1,
					   ISet *objectSet2) ;

HRESULT __declspec(dllexport) CircularDuplicate(long number, double angle, BOOL isTotalAngle,
						  ISet *objectSet1) ;

HRESULT __declspec(dllexport) DuplicateRotate(double rotationAngle, ISet *objectSet1,
						ISet *objectSet2) ;

HRESULT __declspec(dllexport) MirrorInX(ISet *objectSet1, ISet **newObjectset1) ;

HRESULT __declspec(dllexport) MirrorInY(ISet *objectSet1, ISet **newObjectset1) ;

HRESULT __declspec(dllexport) MirrorInBoth(ISet *objectSet1, ISet **newObjectset1) ;
